import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    topCategory: [],
    loading: true,
};

const URL = `${BASE_API_URL_STG}/user/categories/top?status=Active`;

export const getTopCategory = createAsyncThunk(
    "items/getTopCategory",
    async () => {
        const data = await queryResponse(URL, "GET");
        return data;
    }
);

const topCategorySlice = createSlice({
    name: "items",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getTopCategory.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getTopCategory.fulfilled, (state, action) => {
            state.topCategory = action.payload?.records?.data;
            state.loading = false;
        });
        builder.addCase(getTopCategory.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default topCategorySlice.reducer;
